﻿/****** Object:  StoredProcedure [dbo].[VX_SP_BulkImport]    Script Date: 12/4/2014 9:37:15 AM ******/
/****** Object:  StoredProcedure [dbo].[VX_SP_BulkImport]    Script Date: 12/7/2014 7:40:22 PM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[VX_SP_BulkImport]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[VX_SP_BulkImport]
GO

/****** Object:  StoredProcedure [dbo].[VX_SP_BulkImport]    Script Date: 12/7/2014 7:40:22 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE PROCEDURE [dbo].[VX_SP_BulkImport]
AS
  DECLARE @NewCasesCount BIGINT;
  DECLARE @MaxCaseId BIGINT;
  SELECT @NewCasesCount = COUNT(*) FROM #RespondentTemp WHERE resRespondent < 0;
  SELECT @MaxCaseId = Max(resRespondent) FROM #RespondentTemp;
  EXEC VX_SP_VerifyAndUpdateSequence 'Respondent',@MaxCaseId;
  DECLARE @StartSeq BIGINT; 
  exec @StartSeq = VX_SP_GetSequenceRange 'Respondent', @NewCasesCount; 
--Respondent
 MERGE INTO Respondent AS TARGET
 USING #RespondentTemp   AS SOURCE 
 ON (TARGET.ResRespondent = SOURCE.ResRespondent) 
 WHEN MATCHED THEN
 UPDATE SET ProjectId = SOURCE.ProjectId,
  collectMode = CASE WHEN SOURCE.CollectMode <0 THEN TARGET.CollectMode ELSE SOURCE.CollectMode END,
  ModifiedBy = SOURCE.ModifiedBy,
  Modified = GETUTCDATE(),
  ResLanguage =  CASE WHEN SOURCE.ResLanguage  = 0 THEN TARGET.ResLanguage ELSE SOURCE.ResLanguage END,
  ResTimeZone = CASE WHEN SOURCE.ResTimeZone  = 0 THEN TARGET.ResTimeZone ELSE SOURCE.ResTimeZone END,
  ResCallbackDate = IsNull(SOURCE.ResCallBackDate,target.ResCallBackDate),
  ResIntervCall = IsNull(SOURCE.ResIntervCall,target.ResIntervCall),
  ResTimeSlot = IsNull(SOURCE.ResTimeSlot,target.ResTimeSlot),
  ResCallCount = IsNull(SOURCE.ResCallCount,target.ResCallCount),
  ResLastCallDate = IsNull(SOURCE.ResLastCallDate,target.ResLastCallDate),
  ResVersion =IsNull(SOURCE.ResVersion,target.ResVersion),
  ResPriority = CASE WHEN SOURCE.ResPriority  = 0 THEN TARGET.ResPriority ELSE SOURCE.ResPriority END,
  ResCompleted = IsNull(SOURCE.ResCompleted,target.ResCompleted),
  ResConfidPhone = SOURCE.ResConfidPhone,
  ResSeed = SOURCE.ResSeed,
  Resphone = IsNull(SOURCE.Resphone,target.Resphone),
  ResCodeResult = IsNull(SOURCE.ResCodeResult,target.ResCodeResult),
  ResWaveNo = IsNull(SOURCE.ResWaveNo,target.ResWaveNo),
  --ResBlocked = IsNull(SOURCE.ResBlocked,target.ResBlocked),
  ResCompPredictive = IsNull(SOURCE.ResCompPredictive,target.ResCompPredictive),
  ResCall = IsNull(SOURCE.ResCall,target.ResCall),
  ResMonitored = IsNull(SOURCE.ResMonitored,target.ResMonitored),
  ResLastCompQuest = IsNull(SOURCE.ResLastCompQuest,target.ResLastCompQuest),
  ResPreviousCallDate = IsNull(SOURCE.ResPreviousCallDate,target.ResPreviousCallDate),
  ResWaveImportNo =  IsNull(SOURCE.ResWaveImportNo,target.ResWaveImportNo),
  DialingMode = IsNull(SOURCE.DialingMode,target.DialingMode),
  IntLevel = IsNull(SOURCE.IntLevel,target.IntLevel),
  RestrictionOverride = IsNull(SOURCE.RestrictionOverride,target.RestrictionOverride),
  CyclePhoneNumber = IsNull(SOURCE.CyclePhoneNumber,target.CyclePhoneNumber),
  ManualDialing = IsNull(SOURCE.ManualDialing,target.ManualDialing)
 WHEN NOT MATCHED THEN
 INSERT (ResRespondent, ProjectId, CollectMode, ModifiedBy, Modified, ResLanguage, ResTimeZone, ResCallBackDate,
  ResIntervCall, ResTimeSlot, ResCallCount, ResLastCallDate, ResVersion, ResPriority, ResCompleted, ResConfidPhone,
  ResSeed, ResPhone, ResCodeResult, ResWaveNo, ResBlocked, ResCompPredictive, ResCall, ResMonitored, ResLastCompQuest,
  ResPreviousCallDate, ResWaveImportNo, DialingMode, IntLevel, RestrictionOverride,CyclePhoneNumber,ManualDialing)
 VALUES (CASE WHEN SOURCE.ResRespondent < 0 THEN RIGHT ('0000000000' + LTRIM(RTRIM(((ABS(SOURCE.ResRespondent) + @StartSeq) - 1))),10) ELSE RIGHT ('0000000000' + SOURCE.ResRespondent,10) END,
 SOURCE.ProjectId, SOURCE.CollectMode, SOURCE.ModifiedBy, GETUTCDATE(), SOURCE.ResLanguage, SOURCE.ResTimeZone, SOURCE.ResCallBackDate,SOURCE.ResIntervCall, SOURCE.ResTimeSlot, 
 SOURCE.ResCallCount, SOURCE.ResLastCallDate, SOURCE.ResVersion, SOURCE.ResPriority, SOURCE.ResCompleted, SOURCE.ResConfidPhone,SOURCE.ResSeed, SOURCE.ResPhone, 
 SOURCE.ResCodeResult, SOURCE.ResWaveNo, SOURCE.ResBlocked, SOURCE.ResCompPredictive, SOURCE.ResCall, SOURCE.ResMonitored, SOURCE.ResLastCompQuest,
 SOURCE.ResPreviousCallDate, SOURCE.ResWaveImportNo, IsNull(SOURCE.DialingMode,0), IsNull(SOURCE.IntLevel,0), IsNull(SOURCE.RestrictionOverride,0), IsNull(SOURCE.CyclePhoneNumber,0),
 IsNull(SOURCE.ManualDialing,0));
--Response
MERGE Response AS TARGET
USING #ResponseTemp
AS SOURCE 
ON (TARGET.RpsRespondent = SOURCE.RpsRespondent 
AND TARGET.RpsQuestion = SOURCE.RpsQuestion 
AND TARGET.RpsMatrix = SOURCE.RpsMatrix 
AND TARGET.RpsMention = SOURCE.RpsMention 
AND TARGET.RpsType = SOURCE.RpsType)
WHEN MATCHED THEN
UPDATE SET ProjectId = SOURCE.ProjectId,
CollectMode = CASE WHEN SOURCE.CollectMode < 0 THEN TARGET.CollectMode ELSE SOURCE.CollectMode END,
ModifiedBy = SOURCE.modifiedBy,
Modified = SOURCE.Modified,
RpsContent = SOURCE.RpsContent,
RpsOpened = SOURCE.RpsOpened,
CallId = SOURCE.CallId,
[Source] = SOURCE.[Source],
QuestionOrder = SOURCE.QuestionOrder,
ChoiceOrder = SOURCE.ChoiceOrder
WHEN NOT MATCHED THEN
INSERT (RpsRespondent, RpsQuestion, RpsMatrix, RpsMention, RpsType,
ProjectId, CollectMode, ModifiedBy, Modified, RpsContent, RpsOpened, CallId, [Source], QuestionOrder, ChoiceOrder)
VALUES (CASE WHEN SOURCE.RpsRespondent  < 0 THEN RIGHT ('0000000000' + LTRIM(RTRIM(((ABS(SOURCE.RpsRespondent ) + @StartSeq) - 1))),10) ELSE RIGHT ('0000000000' + SOURCE.RpsRespondent ,10) END, 
RpsQuestion, RpsMatrix, RpsMention, RpsType,
ProjectId, CollectMode, modifiedBy, Modified, RpsContent, RpsOpened, CallId, [Source], QuestionOrder, ChoiceOrder);
--Historic
MERGE Historic AS TARGET
USING #HistoricTemp AS SOURCE 
ON (TARGET.HisRespondent = SOURCE.HisRespondent
AND target.HisCallNumber = SOURCE.HisCallNumber)
WHEN MATCHED THEN
UPDATE SET  hisrespondent = SOURCE.HisRespondent,hiscallnumber = SOURCE.HisCallNumber,hisinterviewer = SOURCE.HisInterviewer,hisresult = SOURCE.HisResult,hiscalldate = SOURCE.HisCallDate,
histimeslot = SOURCE.HisTimeSlot,hiscallduration = SOURCE.HisCallDuration,hisdatatype = SOURCE.HisDataType,hisstartquestion = SOURCE.HisStartQuestion,hisendquestion = SOURCE.HisEndQuestion,
hismonitoring = SOURCE.HisMonitoring,hisdialerline = SOURCE.HisDialerLine,hiswait = SOURCE.HisWait,hispause = SOURCE.HisPause,hisfilereference = SOURCE.HisFileReference,hispreviouscalldate = SOURCE.HisPreviousCallDate,
hislifestate = SOURCE.HisLifeState,projectid = SOURCE.projectId,collectmode = SOURCE.collectMode,HisPhone = SOURCE.HisPhone,DialingMode = IsNull(SOURCE.DialingMode, target.DialingMode),
LevelChanged = SOURCE.LevelChanged,Notes = SOURCE.Notes,RuleId = SOURCE.RuleId,ExtRuleId = SOURCE.ExtRuleId,NextCallBack = SOURCE.NextCallBack,IsImported = SOURCE.IsImported,
HisCaseResult = SOURCE.HisCaseResult
WHEN NOT MATCHED THEN
INSERT (hisrespondent,hiscallnumber,hisinterviewer,hisresult,hiscalldate,histimeslot,hiscallduration,hisdatatype,hisstartquestion,hisendquestion,hismonitoring,hisdialerline,hiswait,
hispause,hisfilereference,hispreviouscalldate,hislifestate,projectid,collectmode,HisPhone,DialingMode,LevelChanged,Notes,RuleId,ExtRuleId,NextCallBack,IsImported,HisCaseResult)
VALUES  (CASE WHEN SOURCE.HisRespondent  < 0 THEN RIGHT ('0000000000' + LTRIM(RTRIM(((ABS(SOURCE.HisRespondent ) + @StartSeq) - 1))),10) ELSE RIGHT ('0000000000' + SOURCE.HisRespondent ,10) END,
SOURCE.HisCallNumber,SOURCE.HisInterviewer,SOURCE.HisResult,SOURCE.HisCallDate,SOURCE.HisTimeSlot,SOURCE.HisCallDuration,SOURCE.HisDataType,SOURCE.HisStartQuestion,SOURCE.HisEndQuestion,SOURCE.HisMonitoring,
SOURCE.HisDialerLine,SOURCE.HisWait,SOURCE.HisPause,SOURCE.HisFileReference,SOURCE.HisPreviousCallDate,SOURCE.HisLifeState,SOURCE.projectId,SOURCE.collectMode, SOURCE.HisPhone,
IsNull(SOURCE.DialingMode,0),SOURCE.LevelChanged,SOURCE.Notes,SOURCE.RuleId,SOURCE.ExtRuleId,SOURCE.NextCallBack,SOURCE.IsImported,SOURCE.HisCaseResult);
--HistoricResponse
INSERT INTO HistoricResponse
(Respondent,CallId,Question,Matrix,Mention,Content,OpenEnd,ModifiedBy,Modified)
SELECT CASE WHEN Respondent  < 0 THEN RIGHT ('0000000000' + LTRIM(RTRIM(((ABS(Respondent ) + @StartSeq) - 1))),10) ELSE RIGHT ('0000000000' + Respondent ,10) END,
CallId,Question,Matrix,Mention,Content,OpenEnd,ModifiedBy,GETUTCDATE() FROM #HistoricResponseTemp
--RespondentPIN
MERGE RespondentPIN AS TARGET
USING #RespondentPINTemp AS SOURCE 
ON (TARGET.RspRespondent = SOURCE.RspRespondent)
WHEN MATCHED THEN
UPDATE SET  RspPIN = SOURCE.RspPIN,ProjectId = SOURCE.ProjectId,modifiedBy = SOURCE.modifiedBy,modified = SOURCE.modified
WHEN NOT MATCHED THEN
INSERT (RspRespondent,RspPIN,ProjectId,modifiedBy,modified)
VALUES  (CASE WHEN SOURCE.RspRespondent  < 0 THEN RIGHT ('0000000000' + LTRIM(RTRIM(((ABS(SOURCE.RspRespondent ) + @StartSeq) - 1))),10) ELSE RIGHT ('0000000000' + SOURCE.RspRespondent ,10) END,
SOURCE.RspPIN,SOURCE.ProjectId,SOURCE.ModifiedBy,SOURCE.Modified);
INSERT INTO CaseActionHistoryDetail (ActionId, ActionDetailType, CaseId, Modified, ModifiedBy)
SELECT ActionId, 'Import' + ActionDetailType, CASE WHEN CaseId  < 0 THEN RIGHT ('0000000000' + LTRIM(RTRIM(((ABS(CaseId) + @StartSeq) - 1))),10) ELSE RIGHT ('0000000000' + CaseId ,10) END, Modified, ModifiedBy
FROM #CaseActionHistoryDetailTemp
